#include "openGLControl.h"

COpenGL33Control::COpenGL33Control()
{
	Pause = false;
}

COpenGL33Control::~COpenGL33Control()
{
}

bool COpenGL33Control::Init()
{
	// load files first

	bool Error = false;

	Error |= !ShaderProgram.Load("shader.vert", "shader.frag");

	if(Error)
	{
		return false;
	}

	// get uniform locations

	ShaderProgram.UniformLocations = new GLuint[1];
	ShaderProgram.UniformLocations[0] = glGetUniformLocation(ShaderProgram, "ModelViewProjection");

	// get attrib locations

	ShaderProgram.AttribLocations = new GLuint[2];
	ShaderProgram.AttribLocations[0] = glGetAttribLocation(ShaderProgram, "vert_Color");
	ShaderProgram.AttribLocations[1] = glGetAttribLocation(ShaderProgram, "vert_Position");

	// alocate memory for data

	float *Data = new float[9 * 6];

	// init data

	int i = 0;

	// r, g, b, x, y, z

	Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] = 0.0f; Data[i++] = -0.4f; Data[i++] =  0.1f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] =  0.4f; Data[i++] =  0.1f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] =  0.0f; Data[i++] =  0.7f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] = -0.2f; Data[i++] = -0.6f; Data[i++] =  0.0f;
	Data[i++] = 1.0f; Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] =  0.2f; Data[i++] = -0.6f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] =  0.2f; Data[i++] = -0.1f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] =  0.2f; Data[i++] = -0.1f; Data[i++] =  0.0f;
	Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] = 0.0f; Data[i++] = -0.2f; Data[i++] = -0.1f; Data[i++] =  0.0f;
	Data[i++] = 0.0f; Data[i++] = 1.0f; Data[i++] = 0.0f; Data[i++] = -0.2f; Data[i++] = -0.6f; Data[i++] =  0.0f;

	// set up VBO

	glGenBuffers(1, &VBO);

	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, 9 * 6 * sizeof(float), Data, GL_STATIC_DRAW);

	glBindBuffer(GL_ARRAY_BUFFER, 0); // don't forget to unbind current VBO

	// free memory

	delete [] Data;

	// set up VAO

	glGenVertexArrays(1, &VAO);

	glBindVertexArray(VAO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glVertexAttribPointer(ShaderProgram.AttribLocations[0], 3, GL_FLOAT, GL_FALSE, 24, (void*)0);
	glEnableVertexAttribArray(ShaderProgram.AttribLocations[0]);
	glVertexAttribPointer(ShaderProgram.AttribLocations[1], 3, GL_FLOAT, GL_FALSE, 24, (void*)12);
	glEnableVertexAttribArray(ShaderProgram.AttribLocations[1]);

	glBindVertexArray(0); // don't forget to unbind current VAO

	// set up view matrix
	View[14] = -2.0f;

	return true;
}

void COpenGL33Control::Render(float FrameTime)
{
	static float Angle = 0.0f;

	// multiply matrices
	ModelViewProjection = Projection * View * Model;

	// clear color buffer
	glClear(GL_COLOR_BUFFER_BIT);

	// bind program
	glUseProgram(ShaderProgram);
	glUniformMatrix4fv(ShaderProgram.UniformLocations[0], 1, GL_FALSE, &ModelViewProjection);

	// bind VAO and draw
	glBindVertexArray(VAO);
	glDrawArrays(GL_TRIANGLES, 0, 9);

	// don't forget to unbind current VAO
	glBindVertexArray(0);

	// don't forget to unbind current program
	glUseProgram(0);

	if(!Pause)
	{
		Angle += 22.5f * FrameTime;
		Model = RotationMatrix(Angle, vec3(0.0f, 0.0f, 1.0f)) * TranslationMatrix(0.0f, sin(Angle / 16.0f) * 0.25f, 0.0f);
	}
}

void COpenGL33Control::Resize(int Width, int Height)
{
	this->Width = Width;
	this->Height = Height;

	// set up viewport
	glViewport(0, 0, Width, Height);

	// set up projection matrix
	Projection = PerspectiveProjectionMatrix(45.0f, (float)Width, (float)Height, 0.125f, 512.0f);
}

void COpenGL33Control::Destroy()
{
	// destroy shader program
	ShaderProgram.Destroy();
}
